<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\SummaryRoundBankServiceOption
 *
 * @ORM\Table(name="summary_round_bank_service_option")
 * @ORM\Entity()
 *
 * @ExclusionPolicy("all")
 */
class SummaryRoundBankServiceOption
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails"})
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="balance", type="float")
     */
    private $balance;

    /**
     * @var float
     *
     * @ORM\Column(name="interest", type="float")
     */
    private $interest;

    /**
     * @var float
     *
     * @ORM\Column(name="surcharges", type="float")
     */
    private $surcharges;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="option_id", type="integer")
     */
    private $bankServiceOptionId;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="summaryRoundBankServiceOption")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    protected $round;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="summaryRoundBankServiceOption")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    protected $company;

    /**
     * @ORM\ManyToOne(targetEntity="BankServiceOptions",inversedBy="summaryRoundBankServiceOption")
     * @ORM\JoinColumn(name="option_id", referencedColumnName="id")
     */
    protected $bankServiceOption;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set balance
     *
     * @param float $balance
     * @return SummaryRoundBankServiceOption
     */
    public function setBalance($balance)
    {
        $this->balance = $balance;
    
        return $this;
    }

    /**
     * Get balance
     *
     * @return float 
     */
    public function getBalance()
    {
        return $this->balance;
    }

    /**
     * Set interest
     *
     * @param float $interest
     * @return SummaryRoundBankServiceOption
     */
    public function setInterest($interest)
    {
        $this->interest = $interest;
    
        return $this;
    }

    /**
     * Get interest
     *
     * @return float 
     */
    public function getInterest()
    {
        return $this->interest;
    }

    /**
     * Set surcharges
     *
     * @param float $surcharges
     * @return SummaryRoundBankServiceOption
     */
    public function setSurcharges($surcharges)
    {
        $this->surcharges = $surcharges;
    
        return $this;
    }

    /**
     * Get surcharges
     *
     * @return float 
     */
    public function getSurcharges()
    {
        return $this->surcharges;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return SummaryRoundBankServiceOption
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return SummaryRoundBankServiceOption
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set bankServiceOptionId
     *
     * @param integer $bankServiceOptionId
     * @return SummaryRoundBankServiceOption
     */
    public function setBankServiceOptionId($bankServiceOptionId)
    {
        $this->bankServiceOptionId = $bankServiceOptionId;
    
        return $this;
    }

    /**
     * Get bankServiceOptionId
     *
     * @return integer 
     */
    public function getBankServiceOptionId()
    {
        return $this->bankServiceOptionId;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return SummaryRoundBankServiceOption
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return SummaryRoundBankServiceOption
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set bankServiceOption
     *
     * @param \VM\ApiBundle\Entity\BankServiceOptions $bankServiceOption
     * @return SummaryRoundBankServiceOption
     */
    public function setBankServiceOption(\VM\ApiBundle\Entity\BankServiceOptions $bankServiceOption = null)
    {
        $this->bankServiceOption = $bankServiceOption;
    
        return $this;
    }

    /**
     * Get bankServiceOption
     *
     * @return \VM\ApiBundle\Entity\BankServiceOptions 
     */
    public function getBankServiceOption()
    {
        return $this->bankServiceOption;
    }
}